<?php
namespace chmContacts;

class Task {


/***

	URLS:

		http://cm/wordpress/?chmContacts_task=reset

		http://cm/wordpress/?chmContacts_task=import

		http://cm/wordpress/?chmContacts_task=cleanup

***/



	private static $initialized = false;
	private static $status = [];
	private static $DATA_DIR;

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			self::$DATA_DIR = Storage::getDataDir();
		}
	}

	/*** import person data from json files ***/
	private static function import($output = false) {
		$list = glob(self::$DATA_DIR.'/persons/*.json');
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}
		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
			echo 'TO BE IMPORTED: '.count($list).PHP_EOL.PHP_EOL;
			ob_flush();
    		flush();
		}
		$cnt = 0;
		foreach($list as $file) {
			$cnt++;
			$result = Storage::import(
				json_decode(
					@file_get_contents($file),
					true
				)
			);
			@unlink($file.'.imported');
			@unlink($file.'.excluded');
			if ($result === 'excluded') {
				rename($file, $file.'.excluded');
				if ($output) {
					echo '['.$cnt.' - EXCLUDED] '.$file.PHP_EOL.PHP_EOL;
				}
			} else {
				rename($file, $file.'.imported');
				if ($output) {
					echo '['.$cnt.' - DONE] '.$file.PHP_EOL.PHP_EOL;
				}
			}
			if ($output) {
				ob_flush();
				flush();
			}
		}
	}

	/*** reset import status of person data files ***/
	private static function reset($output = false) {
		$idList = json_decode(@file_get_contents(self::$DATA_DIR.'/list.json'), true);
		sort($idList);
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}

		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
			echo 'CONTACTS: '.count($idList).PHP_EOL.PHP_EOL;
		}
		$cnt = 0;
		foreach($idList as $id) {
			$cnt++;
			$new = self::$DATA_DIR.'/persons/'.$id.'.json';
			$imported = self::$DATA_DIR.'/persons/'.$id.'.json.imported';
			$excluded = self::$DATA_DIR.'/persons/'.$id.'.json.excluded';

			if (!file_exists($new)) {
				if (file_exists($excluded)) {
					rename($excluded, $new);
					if ($output) {
						echo $cnt.' - [DONE] '.basename($excluded).' -> '.basename($new).PHP_EOL;
					}
				} else if (file_exists($imported)) {
					rename($imported, $new);
					if ($output) {
						echo $cnt.' - [DONE] '.basename($imported).' -> '.basename($new).PHP_EOL;
					}
				}
			} else {
				if ($output) {
					echo $cnt.' - [SKIPPED] '.basename($new).PHP_EOL;
				}
			}
		}

		foreach([
			'.json.imported',
			'.json.excluded'
		] as $ext) {
			$fileList = glob(self::$DATA_DIR.'/persons/*'.$ext);

			echo PHP_EOL.PHP_EOL;
			echo 'CLEANUP (*'.$ext.'): '.count($fileList).PHP_EOL.PHP_EOL;
			
			$cnt = 0;
			foreach ($fileList as $file) {
				$cnt++;
				unlink($file);
				if ($output) {
					echo $cnt.' - [DELETED] '.basename($file).PHP_EOL;
				}
			}
		}
	}

	/*** delete missing persons and images with term "chmContacts" that are not linked to existing contacts ***/
	private static function cleanup($output = false) {
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}

		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
		}

		//identify persons to be deleted

		$contacts = Database::getAll(
			'contacts',
			[
				'editable' => 0
			]
		);
		$existingContacts = [];
		foreach($contacts as $contact) {
			array_push($existingContacts, $contact['id']);
		}

		$pCount = 0;
		$personList = json_decode(@file_get_contents(self::$DATA_DIR.'/list.json'));
		if (is_array($personList) && !empty($personList)) {
			$personIDs = [];
			foreach($personList as $personID) {
				array_push($personIDs, md5($personID));
			}

			$deletedPersons = array_diff($existingContacts, $personIDs);
			if ($output) {
				echo 'SCHEDULED FOR DELETION: '.count($deletedPersons).PHP_EOL.PHP_EOL;
			}
			$cnt = 0;
			foreach($deletedPersons as $personID) {
				$cnt++;
				$contact = Database::get(
					'contacts',
					[
						'id' => $personID
					]
				);
				echo $cnt.' - [DELETED] '.$personID.PHP_EOL;
				print_r($contact);
				echo PHP_EOL;
				echo PHP_EOL;

				Storage::deleteContact($personID);
				$pCount++;
			}
		}


		//identify images to be deleted

		$contacts = Database::getAll('contacts');
		$usedImages = [];
		foreach($contacts as $contact) {
			array_push($usedImages, intval($contact['image_post_id']));
		}

		$term = get_term_by('name', Config::get('images')['term'], Config::get('images')['taxonomy']);

		$args = [
			'posts_per_page' => -1,
			'post_type' => 'attachment',
			'post_status' => 'inherit',
			'tax_query' => [
				[
					'taxonomy' => $term->taxonomy,
					'terms' => [
						$term->term_id
					]
				]
			]
		];

		$iCount = 0;
		$query = new \WP_Query($args);
		if ($query->have_posts()) {
			foreach ($query->get_posts() as $post) {
				if (!in_array(intval($post->ID), $usedImages)) {
					wp_delete_post($post->ID, true);
					$iCount++;
				}
			}
		}

		echo PHP_EOL.PHP_EOL;
		echo 'DELETED: '.$iCount.' unused images.'.PHP_EOL.PHP_EOL;
		echo 'DELETED: '.$pCount.' disabled persons.'.PHP_EOL.PHP_EOL;
	}

	/*** run defined tasks ***/
	public static function run($task) {
		self::init();

		if (in_array($task, Config::get('availableTasks'))) {
			self::$task(true);
		}
	}
}
