<?php
namespace chmContacts;

class Admin {


	private static $initialized = false;
	private static $rendered = [
		'editContacts' => false,
		'editUnits' => false,
		'settingsPage' => false,
		'helpPage' => false
	];

	private static function init() {
		Access::check(true);
		if (!self::$initialized) {
			self::$initialized = true;
		}
	}


	/*** show admin page contacts ***/
	public static function editContacts() {
		self::init();
		if (!self::$rendered['editContacts']) {
			self::$rendered['editContacts'] = true;
			echo file_get_contents(Config::get('template_dir').'editContacts.html');
		}
	}


	/*** show admin page units ***/
	public static function editUnits() {
		self::init();
		if (!self::$rendered['editUnits']) {
			self::$rendered['editUnits'] = true;
			echo file_get_contents(Config::get('template_dir').'editUnits.html');
		}
	}

	/*** load settings page ***/
	public static function settingsPage() {
		self::init();

		if (!self::$rendered['settingsPage']) {
			self::$rendered['settingsPage'] = true;

			//check for admin capability
			if (current_user_can('manage_options')) {

				echo Template::render(
					'settings/Settings',
					[
						'namespace' => 'chmContacts',
						'logo' => Config::get('base_url').'res/images/chmContacts.svg',
						'settings' => Config::getSettings()
					],
					true
				);
			} else {
				add_action('wp_after_admin_bar_render', function() {
					echo 'ACCESS DENIED!';
					die;
				});
			}
		}
	}

	/*** load help page ***/
	public static function helpPage() {
		self::init();

		if (!self::$rendered['helpPage']) {
			self::$rendered['helpPage'] = true;

			echo Template::render(
				'Help',
				[
					'namespace' => 'chmContacts',
					'logo' => Config::get('base_url').'res/images/chmContacts.svg'
				],
				true
			);
		}
	}

}
