var chmContacts_UnitsEditor = (function() {
	var $ = jQuery;

	return function($container) {
		var $items, $saveButton;

		function checkInput(input) {
			input.classList[(String(input.dataset.value).trim() != String(input.value).trim()) ? 'add' : 'remove']('modified');
		}

		function checkInputs() {
			var modified;
			modified = (document.querySelectorAll('.chmContacts-unit input.modified').length > 0);
			$container[modified ? 'addClass' : 'removeClass']('modified');
			$saveButton[modified ? 'removeAttr' : 'attr']('disabled', 'disabled');
		}

		function renderItem(item) {
			return $('<div>').addClass('chmContacts-unit  chmContacts-forceColumns_unit').on('click', function() {
				$(this).find('input').focus();
			}).append(
				$('<div>').addClass('chmContacts-unit-title').text(item.name),
				$('<input>').addClass('chmContacts-unit-input').val(item.phone_internal).attr({
					'data-unit': item.id,
					'data-field': 'phone_internal',
					'data-value': item.phone_internal
				}).on('blur', function() {
					$('.chmContacts-unit').removeClass('has-focus');
				}).on('focus', function() {
					$(this).closest('.chmContacts-unit').addClass('has-focus');
				}).on('input change', function() {
					checkInput(this);
					checkInputs();
				}).on('click', function(event) {
					event.stopPropagation();
				})
			);
		}

		function save() {
			var units;
			units = {};
			$.each(document.querySelectorAll('.chmContacts-unit input.modified'), function() {
				var unit;
				unit = {};
				unit[this.dataset.field] = String(this.value).trim();
				units[this.dataset.unit] = unit;
			});
			chmContacts.request(
				{
					action: 'updateUnits',
					units: units
				},
				function(resp) {
					if (resp.response.done) {
						$.each(document.querySelectorAll('.chmContacts-unit input.modified'), function() {
							var unitData;
							this.value = String(this.value).trim();
							this.dataset.value = this.value;
							this.classList.remove('modified');
						});
						checkInputs();
					} else {
						alert('Fehler beim Speichern.');
					}
				}
			);
		}

		$items = $container.find('.chmContacts-units-items');

		$saveButton = $container.find('[data-button-action="save"]').on('click', function() {
			save();
		});

		chmContacts.request(
			{
				action: 'listUnits'
			},
			function(resp) {
				$.each(resp.response.units, function() {
					$items.append(
						renderItem(this)
					);
				});
			}
		);


	};
})();
