<?php
namespace chmContacts;

class Shortcode {


	private static $initialized = false;
	private static $shortcodes = [];

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			self::$shortcodes = [
				'chmContact' => [
					'defaults' => [
						'nr' => 0,
						'id' => '',
						'mode' => 'compact',
						'template' => ''
					],
					'values' => [
						'mode' => [
							'compact',
							'large'
						]
					],
					'render' => function($template, $content, $settings) {
						if (Config::get('ENABLE_SHORTCODES')) {
							$contact = Storage::getContact($settings['nr'], 'contact_number', false);
							if (!empty($contact)) {
								if (!empty($settings['template'])) {
									$templateFile = Config::get('theme_dir').'/'.Helper::normalizeRelativePath(Config::get('theme_template_dir')).'/'.$settings['template'].'.html';
									if (file_exists($templateFile)) {
										$template = @file_get_contents($templateFile);
									} else {
										if (Config::get('DEBUG')) {
											$template = '<div style="color:red;background-color:white;padding:0.5em;">[chmContact] Template not found:<br/>'.$templateFile.'</div>'.$template;
										}
									}
								}

								$markers = $contact;
								$markers['class'] = implode(' ', [
									empty($contact['room']) ? 'type-person' : 'type-room',
									empty($contact['email']) ? 'no-email' : 'has-email',
									empty($contact['phone_internal']) ? 'no-phone-internal' : 'has-phone-internal',
									empty($contact['phone_dect']) ? 'no-phone-dect' : 'has-phone-dect',
									empty($contact['fax']) ? 'no-fax' : 'has-fax',
								]);
								return Helper::replaceMarkers(
									$template,
									$markers
								);
							} else {
								if (Config::get('DEBUG')) {
									return '<div style="color:red;background-color:white;padding:0.5em;">[chmContact] Contact not found: '.$settings['nr'].'</div>';
								} else {
									return '';
								}
							}
						} else {
							if (Config::get('DEBUG')) {
								return '<div style="color:red;background-color:white;padding:0.5em;">[chmContact] Shortcode disabled in plug-in settings</div>';
							} else {
								return '';
							}
						}
					}
				],
				'chmContacts_Search' => [
					'defaults' => [
						'text' => 'chmContacts Search'
					],
					'values' => [
					],
					'render' => function($template, $content, $settings) {
						if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_SEARCH')) {
							$markers = [
								'text' => $settings['text'],
								'languages' => rawurlencode(json_encode(Storage::getList('languages', true))),
								'units' => rawurlencode(json_encode(Storage::getList('units', true))),
								'jobs' => rawurlencode(json_encode(Storage::getList('jobs', true))),
								'representations' => rawurlencode(json_encode(Storage::getList('representations', true)))
							];
							return Helper::replaceMarkers(
								$template,
								$markers
							);
						} else {
							return '<div style="background-color:#ccc;padding:1rem;border-radius:5px;color:#0aa;"><h3>Kontaktsuche: <i>bald vefügbar...</i></h3></div>';
						}
					}
				],
				'chmContacts_Welcome' => [
					'defaults' => [
						'title-preload' => 'Neu...',
						'title-male' => 'Neuer Mitarbeiter',
						'title-female' => 'Neue Mitarbeiterin',
						'title-none' => '',
						'title-list' => 'Alle neuen Mitarbeiter/innen',
						'show-more' => 'Zeige mehr...'
					],
					'values' => [
					],
					'render' => function($template, $content, $settings) {
						if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_WELCOME')) {
							$newContacts = Storage::getNewContacts(2);

							$markers = [
								'title-preload' => $settings['title-preload'],
								'title-male' => base64_encode($settings['title-male']),
								'title-female' => base64_encode($settings['title-female']),
								'title-none' => base64_encode($settings['title-none']),
								'list' => '', //$newContacts['list'][0],
								'showMore' => $settings['show-more'],
								'classShowMore' => (count($newContacts['list']) > 1) ? 'show' : 'hide',
								'listTitle' => $settings['title-list']
							];

							// print_r($newContacts['list']);

							// print_r($markers);

							// echo count($newContacts['list']);
							// die;


							return Helper::replaceMarkers(
								$template,
								$markers
							);
						} else {
							return '<div style="background-color:#ccc;padding:1rem;border-radius:5px;color:#0aa;"><h3>Begrüßung neuer Mitarbeiter/innen</h3><p><i>bald vefügbar...</i></p></div>';
						}
					}
				],
				'chmContacts_Languages' => [
					'defaults' => [
						'show' => ''
					],
					'values' => [
					],
					'render' => function($template, $content, $settings) {
						if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_LANGUAGES_TABLE')) {
							$contacts = Storage::listContacts(0, PHP_INT_MAX, false)['contacts'];
							$rows = [];
							foreach ($contacts as $contact) {
								if (($contact['languagesCount'] > 0) || ($settings['show'] == 'all')) {
									array_push(
										$rows,
										Template::render('contactLanguageRow', [
											'title' => $contact['title'],
											'salutation' => $contact['salutation'],
											'lastName' => $contact['last_name'],
											'firstName' => $contact['first_name'],
											'phoneDECT' => $contact['phone_dect'],
											'phoneInternal' => $contact['phone_internal'],
											'email' => $contact['email'],
											'units' => ($contact['unitsCount'] > 0) ? '<li>'.implode('</li>'.PHP_EOL.'<li>', explode(', ', $contact['unitsList'])).'</li>' : '',
											'jobs' => ($contact['jobsCount'] > 0) ? '<li>'.implode('</li>'.PHP_EOL.'<li>', explode(', ', $contact['jobsList'])).'</li>' : '',
											'languages' => ($contact['languagesCount'] > 0) ? '<li>'.implode('</li>'.PHP_EOL.'<li>', explode(', ', $contact['languagesList'])).'</li>' : '',
										])
									);
								}
							}
							$markers = [
								'rows' => implode(PHP_EOL, $rows)
							];
							return Helper::replaceMarkers(
								$template,
								$markers
							);
						} else {
							return '<div style="background-color:#ccc;padding:1rem;border-radius:5px;color:#0aa;"><h3>Sprachen</h3>Zur Ausgabe der Sprachkenntnisse muss der Shortcode im Backend unter <i>chmContacts</i> &rarr; <i>Einstellungen</i> aktiviert werden.</div>';
						}
					}
				],

			];
		}
	}

	/*** prepare rendering of shortcode and call renderer ***/
	public static function render($shortcode, $content, $atts) {
		self::init();

		//check if shortcode exists
		if (array_key_exists($shortcode, self::$shortcodes)) {

			// normalize attribute keys, lowercase
			$atts = array_change_key_case((array)$atts, CASE_LOWER);

			// override default attributes with user attributes
			$settings = shortcode_atts(self::$shortcodes[$shortcode]['defaults'], $atts, $shortcode);

			$template = @file_get_contents(Config::get('template_dir').'shortcode/'.$shortcode.'.html');

			return self::$shortcodes[$shortcode]['render']($template, $content, $settings);
		} else {
			return '';
		}
	}

	/*** list of available short codes ***/
	public static function getList() {
		self::init();
		return self::$shortcodes;
	}

}
