<?php
if ( ! defined( 'ABSPATH' ) ) exit;

return call_user_func(function() {

	$rootDir = realpath(ABSPATH);
	$themeDir = realpath(get_template_directory());

	return [
		'DEBUG' => false,
		'MODIFY' => [
			'DEBUG' => [
				'type' => 'bool',
				'label' => 'Debug-Modus aktivieren'
			],
			'SECRET' => [
				'type' => 'text',
				'label' => 'Secret:<br><i>Wird u.a. für die Kontakt-Synchronisation benötigt.</i>'
			],
			'ENABLE_SHORTCODES' => [
				'type' => 'bool',
				'label' => 'Shortcodes aktivieren'
			],
			'ENABLE_SEARCH' => [
				'type' => 'bool',
				'label' => 'Suchfunktion im Frontend erlauben'
			],
			'ENABLE_WELCOME' => [
				'type' => 'bool',
				'label' => 'Willkommens-Modul (neue Mitarbeiter) im Frontend erlauben'
			],
			'theme_template_dir' => [
				'type' => 'text',
				'label' => 'Template-Ordner für Kontaktboxen:<br/><i>Relativ zu:</i> <strong>'.$themeDir.'/</strong>'
			],
			'data_dir' => [
				'type' => 'text',
				'label' => 'Daten-Ordner für Import:<br/><i>Relativ zu:</i> <strong>'.$rootDir.'/</strong>'
			],
			'contact_new_days' => [
				'type' => 'int',
				'label' => 'Anzahl der Tage, die ein Kontakt als "neu" angesehen wird:<br><i>Berechnet anhand des Eintrittsdatums in Relation zum aktuellen Datum.'
			],
			'hiddenCompanies' => [
				'type' => 'list',
				'label' => 'Ausgeblendete Unternehmen:'
			],
			'hiddenUnits/global' => [
				'type' => 'list',
				'label' => 'Ausgeblendete Abteilungen (global):'
			],
			'hiddenUnits/welcome' => [
				'type' => 'list',
				'label' => 'Ausgeblendete Abteilungen (neue Mitarbeiter):'
			],
		],
		'ENABLE_SHORTCODES' => true,
		'ENABLE_SEARCH' => false,
		'ENABLE_WELCOME' => false,
		'SECRET' => '',
		'ENVIRONMENT' => [
			'chmContacts_UPDATE_HOST' => 'wp-plugins.chm.software',
			'chmContacts_UPDATE_CACHE' => true,
			'chmContacts_UPDATE_SSL_VERIFY' => true			
		],
		'accessAPI' => [
			'controller' => '\\chmAccess\\API',
			'method' => 'checkModuleAccess'
		],
		'availableTasks' => [
			'check',
			'update',
			'import',
			'reset',
			'cleanup'
		],
		'db_version' => '1.0',
		'ajax_action' => 'chmContacts_ajaxRequest',
		//fields for keyword search
		'contact_search_fields' => [
			//'contact_number'
			// 'salutation',
			// 'title',
			'name_prefix',
			'first_name',
			'last_name',
			'email',
			'phone_internal',
			'phone_dect',
			'fax',
			'room',
		],
		//interval to define a person as "new contact"
		'contact_new_days' => 40,
		//items for keyword search (from mappings)
		'contact_search_items' => [
			'units',
			'jobs',
			'representations',
			'languages'
		],
		'contact_save_fields' => [
			'contact_number',
			'salutation',
			'title',
			'name_prefix',
			'first_name',
			'last_name',
			'email',
			'phone_internal',
			'phone_dect',
			'fax',
			'room',
			'start_date',
		],
		'contact_public_fields' => [
			'id',
			'salutation',
			'title',
			'name_prefix',
			'first_name',
			'last_name',
			'email',
			'phone_internal',
			'phone_dect',
			'fax',
			'room',
			'companiesList',
			'unitsList',
			'jobsList',
			'representationsList',
			'languagesList',
			'companiesCount',
			'unitsCount',
			'jobsCount',
			'representationsCount',
			'languagesCount',
			'image',
			'imageThumb',
			'imageIcon',
		],
		'images' => [
			'term' => 'chmContacts',
			'taxonomy' => 'mediamatic_wpfolder'
		],
		'image_sizes' => [
			'imageIcon' => [
				'id' => 'chmContacts-icon',
				'width' => 100,
				'height' => 125,
				'crop' => ['center', 'center']
			],
			'imageThumb' => [
				'id' => 'chmContacts-thumb',
				'width' => 200,
				'height' => 250,
				'crop' => ['center', 'center']
			],
			'image' => [
				'id' => 'chmContacts-image',
				'width' => 800,
				'height' => 1000,
				'crop' => ['center', 'center']
			]
		],
		'tables' => [
			'contacts' => 'chmcontacts_contacts',
			'companies' => 'chmcontacts__items__companies',
			'units' => 'chmcontacts__items__units',
			'jobs' => 'chmcontacts__items__jobs',
			'representations' => 'chmcontacts__items__representations',
			'languages' => 'chmcontacts__items__languages',
			'map_items' => 'chmcontacts__map__contacts_items'
		],
		//the fields in the array are emptied before importing the contact if the given field is NOT empty
		'emptyFields' => [
				'organigramm' => [
					'abteilung1',
					'abteilung2',
				]
		],
		'mappings' => [
			'companies' => [
				'type' => 'string',
				'fields' => [
					'gesellschaft'
				]
			],
			'units' => [
				'type' => 'string',
				'fields' => [
					'abteilung1',
					'abteilung2',
					'organigramm'
				]
			],
			'jobs' =>  [
				'type' => 'string',
				'fields' => [
					'taetikeit1',
					'taetigkeit2'
				]
			],
			'representations' =>  [
				'type' => 'csv',
				'fields' => [
					'beauftragter'
				]
			],
			'languages' =>  [
				'type' => 'csv',
				'fields' => [
					'sprachkenntnisse'
				]
			],
		],
		//blacklist for units in frontend
		'hiddenCompanies' => [
			'Honorarkräfte',
			'Servicedienste',
			// 'Krankenhaus Porz',
			// 'MVZ',
			// 'VIP',
		],
		//blacklist for units in frontend
		'hiddenUnits' => [
			'welcome' => [
				'PJ-ler'
			],
			'global' => [
				'Honorarkräfte',
			]
		],
		//blacklist for jobs in frontend
		'hiddenJobs' => [
			'welcome' => [
				'PJ-ler'
			]
		],
		'mime_types' => [
			'image/png' => 'png',
			'image/gif' => 'gif',
			'image/jpg' => 'jpg',
			'image/jpeg' => 'jpg'
		],
		'root_dir' => $rootDir,
		'theme_dir' => $themeDir,
		'data_dir' => 'chm-contacts-sync/data/',
		'theme_template_dir' => 'templates/chmContacts/',
		'template_dir' => __DIR__.'/../res/templates/',
		'css_dir' => __DIR__.'/../res/css/',
		'css_url_part' => 'res/css/',
		'js_dir' => __DIR__.'/../res/js/',
		'js_url_part' => 'res/js/',
		'base_url' => plugin_dir_url(realpath(__DIR__.'/..').'/chm-contacts.php'),
		'wp_includes' => [
			ABSPATH.'wp-admin/includes/media.php',
			ABSPATH.'wp-admin/includes/file.php',
			ABSPATH.'wp-admin/includes/image.php',
		]
	];
});