<?php
namespace chmContacts;

class Task {


/***

	URLS:

		http://cm/wordpress/?chmContacts_task=reset

		http://cm/wordpress/?chmContacts_task=import

		http://cm/wordpress/?chmContacts_task=cleanup

***/



	private static $initialized = false;
	private static $status = [];
	private static $DATA_DIR;

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			self::$DATA_DIR = Config::get('root_dir').'/'.Helper::normalizeRelativePath(Config::get('data_dir'));
		}
	}

	/*** check for necessary data updates ***/
	private static function check($output = false) {
		$checksums = json_decode(@file_get_contents(self::$DATA_DIR.'/../checksum.json'), true);
		if (!is_array($checksums)) {
			$checksums = [];
		}

		$id = $_GET['id'];
		$checksum = $_GET['checksum'];

		$needsUpdate = (!array_key_exists($id, $checksums) || ($checksums[$id] != $checksum));

		if ($output) {
			header('Content-type:application/json; charset=utf-8');
			echo json_encode([
				'success' => true,
				'needs_update' => $needsUpdate
			]);
			die;
		}

		return $needsUpdate;
	}

	/*** perform single data update with given data ***/
	private static function update($output = false) {
		$success = false;
		$errors = [];

		if (self::check()) {
			$dataRaw = file_get_contents('php://input');
			if (md5(Config::get('SECRET').$dataRaw) == $checksum) {
				$checkData = json_decode($dataRaw, true);
				if (is_array($checkData)) {
					$personFile = __DIR__.'/data/persons/'.$checkData['id'].'.json';
					file_put_contents($personFile, $dataRaw);
					chmod($personFile, 0777);
					$checksums[$id] = $checksum;
					file_put_contents(__DIR__.'/data/checksum.json', json_encode($checksums));
					$success = true;
				} else {
					array_push($errors, 'INVALID_DATA');
				}
			} else {
				array_push($errors, 'CHECKSUM_FAILED');
			}
		} else {
			$success = true;
		}

		if ($output) {
			header('Content-type:application/json; charset=utf-8');
			echo json_encode([
				'success' => $success,
				'errors' => $errors
			]);
			die;
		}

		return $success;

	}

	/*** import person data from json files ***/
	private static function import($output = false) {
		$list = glob(self::$DATA_DIR.'/persons/*.json');
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}
		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
			echo 'TO BE IMPORTED: '.count($list).PHP_EOL.PHP_EOL;
		}
		foreach($list as $file) {
			Storage::import(
				json_decode(
					@file_get_contents($file),
					true
				)
			);
			rename($file, $file.'.imported');
			if ($output) {
				echo '[DONE] '.$file.PHP_EOL.PHP_EOL;
			}
		}
	}

	/*** reset import status of person data files ***/
	private static function reset($output = false) {
		$list = glob(self::$DATA_DIR.'/persons/*.json.imported');
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}

		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
			echo 'TO BE RESET: '.count($list).PHP_EOL.PHP_EOL;
		}
		foreach($list as $file) {
			$newFile = substr($file, 0, -strlen('.imported'));
			if (!file_exists($newFile)) {
				rename($file, $newFile);
				if ($output) {
					echo '[DONE] '.$newFile.PHP_EOL;
				}
			} else {
				if ($output) {
					echo '[SKIPPED] '.$newFile.PHP_EOL;
				}
			}
		}
	}

	/*** delete missing persons and images with term "chmContacts" that are not linked to existing contacts ***/
	private static function cleanup($output = false) {
		if ($output) {
			header('Content-type:text/plain; charset=utf-8');
		}

		if ($output) {
			echo 'DATE: '.date('d.m.Y H:i:s').PHP_EOL.PHP_EOL;
		}

		//identify persons to be deleted

		$contacts = Database::getAll(
			'contacts',
			[
				'editable' => 0
			]
		);
		$existingContacts = [];
		foreach($contacts as $contact) {
			array_push($existingContacts, $contact['id']);
		}

		$pCount = 0;
		$personList = json_decode(@file_get_contents(self::$DATA_DIR.'/list.json'));
		if (is_array($personList) && !empty($personList)) {
			$personIDs = [];
			foreach($personList as $personID) {
				array_push($personIDs, md5($personID));
			}

			$deletedPersons = array_diff($existingContacts, $personIDs);
			foreach($deletedPersons as $personID) {
				$contact = Database::get(
					'contacts',
					[
						'id' => $personID
					]
				);
				echo 'DELETED:'.PHP_EOL;
				print_r($contact);
				echo PHP_EOL;

				Storage::deleteContact($personID);
				$pCount++;
			}
		}


		//identify images to be deleted

		$contacts = Database::getAll('contacts');
		$usedImages = [];
		foreach($contacts as $contact) {
			array_push($usedImages, intval($contact['image_post_id']));
		}

		$term = get_term_by('name', Config::get('images')['term'], Config::get('images')['taxonomy']);

		$args = [
			'posts_per_page' => -1,
			'post_type' => 'attachment',
			'post_status' => 'inherit',
			'tax_query' => [
				[
					'taxonomy' => $term->taxonomy,
					'terms' => [
						$term->term_id
					]
				]
			]
		];

		$iCount = 0;
		$query = new \WP_Query($args);
		if ($query->have_posts()) {
			foreach ($query->get_posts() as $post) {
				if (!in_array(intval($post->ID), $usedImages)) {
					wp_delete_post($post->ID, true);
					$iCount++;
				}
			}
		}

		echo 'DELETED: '.$iCount.' unused images.'.PHP_EOL.PHP_EOL;
		echo 'DELETED: '.$pCount.' disabled persons.'.PHP_EOL.PHP_EOL;
	}

	/*** run defined tasks ***/
	public static function run($task) {
		self::init();

		if (in_array($task, Config::get('availableTasks'))) {
			self::$task(true);
		}
	}
}
