chmContacts_Backend = (function() {
	var that, $;

	$ = jQuery;

	$(document).ready(function() {

		// console.log(chmContacts_params);


		$('.chmContacts_ControlPanel').each(function() {
			chmContacts_ControlPanel($(this));
		});
	});


	that = {
		renderHeader: function() {
			return $('<thead>').append($('<tr>').append(
				$('<th>').text('Raum'),
				$('<th>').text('Anrede'),
				$('<th>').text('Titel'),
				$('<th>').text('Vorname'),
				$('<th>').text('Nachname'),
				$('<th>').text('Personalnummer'),
				$('<th>').text('E-Mail'),
				$('<th>').text('Intern'),
				$('<th>').text('DECT'),
				$('<th>').text('Fax'),
				$('<th>').text('Eintritt')
			));
		},
		render: function(contact) {
			return $('<tr>').addClass(contact.editable ? 'editable' : 'not-editable').append(
				$('<td>').attr('data-field', 'room').text(contact.room),
				$('<td>').attr('data-field', 'salutation').text(contact.salutation),
				$('<td>').attr('data-field', 'title').text(contact.title),
				$('<td>').attr('data-field', 'first_name').text(contact.first_name),
				$('<td>').attr('data-field', 'last_name').text(that.getLastName(contact)),
				$('<td>').attr('data-field', 'contact_number').text(contact.contact_number),
				$('<td>').attr('data-field', 'email').text(contact.email),
				$('<td>').attr('data-field', 'phone_internal').text(contact.phone_internal),
				$('<td>').attr('data-field', 'phone_dect').text(contact.phone_dect),
				$('<td>').attr('data-field', 'fax').text(contact.fax),
				$('<td>').attr('data-field', 'start_date').text(contact.start_date ? ((contact.start_date != '0000-00-00') ? contact.start_date : '') : 'unbekannt')
			);
		},
		getLastName: function(contact) {
			return String(contact.name_prefix+' '+contact.last_name).trim();
		},
		editForm: function(contact) {
			var $form, $row, $col, fields, field, items, item;
			fields = {
				contact_number: 'Personalnummer',
				salutation: 'Anrede',
				title: 'Titel',
				first_name: 'Vorname',
				name_prefix: 'Namens-Präfix',
				last_name: 'Nachname',
				email: 'E-Mail',
				start_date: 'Eintrittsdatum',
				phone_internal: 'Telefon intern',
				phone_dect: 'Telefon DECT',
				fax: 'Fax',
				room: 'Raum'
			};

			items = {
				'companies': 'Unternehmen',
				'units': 'Abteilung(en)',
				'jobs': 'Tätigkeit(en)',
				'representations': 'Beauftragung(en)',
				'languages': 'Sprache(n)'
			};


			$form = $('<div>');

			$row = $('<div>').addClass('chm-row');

			$col = $('<div>').addClass('chm-col');

			for  (field in fields) {
				$col.append(
					$('<div>').append(
						$('<label>').text(fields[field]).attr({
							for: 'input_'+field
						}),
						$('<input>').attr({
							'data-field': field,
							id: 'input_'+field,
							value: contact[field]
						})
					)
				);
			}

			$row.append($col);

			$col = $('<div>').addClass('chm-col');

			$col.append(
				$('<div>').addClass('chm-image').append(
					$('<img>').addClass('contact-image').attr('src', contact.image ? contact.image : '')
				)
			);

			$row.append($col);

			$form.append($row);


			$row = $('<div>').addClass('chm-row');

			for (item in items) {
				$col = $('<div>').addClass('chm-col-small');

				$col.append(
					$('<label>').text(items[item]).attr({
						for: 'item_'+item
					}),
					$('<div>').addClass('chm-note').text('Mehrfachauswahl mit STRG und SHIFT'),
					$('<select>').addClass('item-select').attr({
						multiple: 'multiple',
						'data-item': item,
						size: 2,
						id: 'item_'+item
					}),
					$('<div>').addClass('button-link').text('+ Hinzufügen').attr({
						'data-add-item': item
					})
				);

				$row.append($col);
			}


			$form.append($row);

			return $form;
		}
	};

	return that;

})();