<?php

call_user_func(function() {
	//autoload controllers
	foreach(glob(chmContacts_DIR.'/controllers/*.php') as $controller) {
		require_once($controller);
	}


	$envFile = __DIR__.'/../_config/environment.php';

	$environmentOverride = file_exists($envFile) ? require($envFile) : [];

	$environment = \chmContacts\Config::get('ENVIRONMENT');

	foreach ($environmentOverride as $const => $value) {
		if (array_key_exists($const, $environment)) {
			$environment[$const] = $value;
		}
	}

	foreach ($environment as $const => $value) {
		if (!defined($const)) {
			define($const, $value);
		}
	}

});


//register activation hook
if (function_exists('register_activation_hook')) {
	register_activation_hook(chmContacts_FILE, function() {
		\chmContacts\Setup::activate();
	});
}

//register deactivation hook
if (function_exists('register_deactivation_hook')) {
	register_deactivation_hook(chmContacts_FILE, function() {
		\chmContacts\Setup::deactivate();
	});
}

//register uninstall hook
//TODO: fix error "technical issues" when activating uninstall hook
if (function_exists('register_uninstall_hook')) {
	// register_uninstall_hook(chmContacts_FILE, function() {
	// 	\chmContacts\Setup::uninstall();
	// });
}

//wait for core load and check for special actions
add_action('wp_loaded', function() {
	//include necessary files
	foreach (\chmContacts\Config::get('wp_includes') as $include) {
		require_once($include);
	}

	$task = @$_GET['chmContacts_task'];
	if (!empty($task)) {
		\chmContacts\Task::run($task);
		die;
	}
});

//add admin menu module
add_action('admin_menu', function() {
	if (\chmContacts\Access::check()) {
		add_menu_page(
			'chmContacts - Kontakte',
			'chmContacts',
			'edit_posts', //access for backend users only
			'chmContacts',
			function() {
				\chmContacts\Admin::editContacts();
			},
			plugin_dir_url(chmContacts_FILE) . 'res/images/chmContacts.svg',
			20
		);	
		add_submenu_page(
			'chmContacts',
			'chmContacts - Kontakte',
			'Kontakte',
			'edit_posts', //access for backend users only
			'chmContacts',
			function() {
				\chmContacts\Admin::editContacts();
			}
		);	
		add_submenu_page(
			'chmContacts',
			'chmContacts - Abteilungen',
			'Abteilungen',
			'edit_posts', //access for backend users only
			'chmContacts_Units',
			function() {
				\chmContacts\Admin::editUnits();
			}
		);	
		add_submenu_page(
			'chmContacts',
			'chmContacts - Einstellungen',
			'Einstellungen',
			'manage_options', //access for admin users only
			'chmContacts_options',
			function() {
				\chmContacts\Admin::settingsPage();
			}
		);
		add_submenu_page(
			'chmContacts',
			'chmContacts - Hilfe',
			'Hilfe',
			'edit_posts', //access for backend users only
			'chmContacts_help',
			function() {
				\chmContacts\Admin::helpPage();
			}
		);

		//settings link
		add_options_page(
			'chmContacts - Einstellungen',
			'chmContacts',
			'manage_options', //access for admin only
			'chmContacts_options',
			function() {
				\chmContacts\Admin::settingsPage();
			}
		);

		// link to settings in plug-in list
		add_filter(
			'plugin_action_links_'.plugin_basename(chmContacts_FILE),
			function($links) {
				$newLinks = [
					'settings' => '<a href="'.admin_url('options-general.php?page=chmContacts_options').'">Einstellungen</a>'
				];
				foreach ($links as $key => $value) {
					$newLinks[$key] = $value;
				}
				return $newLinks;
			}
		);

	}
});

//load admin scripts
add_action('admin_enqueue_scripts', function() {
	//load backend JS and CSS
	\chmContacts\Helper::loadScripts('backend');
});

add_action('wp_ajax_nopriv_'.\chmContacts\Config::get('ajax_action'), function() {
	\chmContacts\Ajax::request(false);
});
add_action('wp_ajax_'.\chmContacts\Config::get('ajax_action'), function() {
	\chmContacts\Ajax::request(true);
});

//init actions
add_action('init', function() {

	//load frontend JS and CSS
	\chmContacts\Helper::loadScripts('frontend');

	//define image sizes
	foreach(\chmContacts\Config::get('image_sizes') as $key => $imageSize) {
		add_image_size($imageSize['id'], $imageSize['width'], $imageSize['height'], $imageSize['crop']); // width, height, crop
	}

	//register shortcodes
	foreach (\chmContacts\Shortcode::getList() as $shortcode => $config) {
		add_shortcode($shortcode, function($atts = [], $content = null, $tag = '') {
			return \chmContacts\Shortcode::render($tag, $content, $atts);
		});	
	}
});


if( ! class_exists( 'chmContacts_UpdateChecker' ) ) {

	class chmContacts_UpdateChecker {

		public $plugin_slug;
		public $version;
		public $cache_key;
		public $cache_allowed;

		private $hosts;

		public function __construct() {

			$this->plugin_slug = plugin_basename( chmContacts_DIR );
			$this->version = get_file_data(chmContacts_FILE, ['Version' => 'Version'])['Version'];
			$this->cache_key = 'chmContacts_custom_update';
			$this->cache_allowed = chmContacts_UPDATE_CACHE;

			add_filter( 'plugins_api', array( $this, 'info' ), 20, 3 );
			add_filter( 'site_transient_update_plugins', array( $this, 'update' ) );
			add_action( 'upgrader_process_complete', array( $this, 'purge' ), 10, 2 );

			add_filter( 'http_request_host_is_external', function($external = false, $host = '', $url = '') {
				return ($host == chmContacts_UPDATE_HOST) ? true : $external;
			}, 10, 2);

			add_filter( 'http_request_reject_unsafe_urls', function($pass_url = false, $url = '') {
				return (strpos($url, $this->plugin_slug) !== false) ? false : $pass_url;
			}, 10, 2);

			add_filter( 'http_request_args', function($parsed_args = [], $url = '') {
				if (strpos($url, $this->plugin_slug) !== false) {
					$parsed_args['sslverify'] = false;
				}
				return $parsed_args;
			});

			add_filter( 'https_ssl_verify', function($ssl_verify = true, $url = '') {
				return chmContacts_UPDATE_SSL_VERIFY && $ssl_verify;
			});

		}

		public function request(){

			$remote = get_transient( $this->cache_key );

	
			if( false === $remote || ! $this->cache_allowed ) {

				$remote = wp_remote_get(
					'https://'.chmContacts_UPDATE_HOST.'/chm-contacts/info',
					array(
						'timeout' => 10,
						'sslverify' => chmContacts_UPDATE_SSL_VERIFY,
						'headers' => array(
							'Accept' => 'application/json'
						)
					)
				);

				if(
					is_wp_error( $remote )
					|| 200 !== wp_remote_retrieve_response_code( $remote )
					|| empty( wp_remote_retrieve_body( $remote ) )
				) {
					return false;
				}

				set_transient( $this->cache_key, $remote, floor(DAY_IN_SECONDS / 24) );

			}

			$remote = json_decode( wp_remote_retrieve_body( $remote ) );

			return $remote;

		}


		function info( $res, $action, $args ) {

			// do nothing if you're not getting plugin information right now
			if( 'plugin_information' !== $action ) {
				return false;
			}

			// do nothing if it is not our plugin
			if( $this->plugin_slug !== $args->slug ) {
				return false;
			}

			// get updates
			$remote = $this->request();

			if( ! $remote ) {
				return false;
			}

			$res = new stdClass();

			$res->name = $remote->name;
			$res->slug = $remote->slug;
			$res->version = $remote->version;
			$res->tested = $remote->tested;
			$res->requires = $remote->requires;
			$res->author = $remote->author;
			$res->author_profile = $remote->author_profile;
			$res->download_link = $remote->download_url;
			$res->trunk = $remote->download_url;
			$res->requires_php = $remote->requires_php;
			$res->last_updated = $remote->last_updated;

			$res->sections = array(
				'description' => $remote->sections->description,
				'installation' => $remote->sections->installation,
				'changelog' => $remote->sections->changelog
			);

			if( ! empty( $remote->banners ) ) {
				$res->banners = array(
					'low' => $remote->banners->low,
					'high' => $remote->banners->high
				);
			}

			return $res;

		}

		public function update( $transient ) {

			if ( empty($transient->checked ) ) {
				return $transient;
			}

			$remote = $this->request();

			if(
				$remote
				&& version_compare( $this->version, $remote->version, '<' )
				&& version_compare( $remote->requires, get_bloginfo( 'version' ), '<' )
				&& version_compare( $remote->requires_php, PHP_VERSION, '<' )
			) {
				$res = new stdClass();
				$res->slug = $this->plugin_slug;
				$res->plugin = plugin_basename(chmContacts_FILE);
				$res->new_version = $remote->version;
				$res->tested = $remote->tested;
				$res->package = $remote->download_url;

				$transient->response[ $res->plugin ] = $res;

	    	}

			return $transient;

		}

		public function purge(){

			if (
				$this->cache_allowed
				// && 'update' === $options['action']
				// && 'plugin' === $options[ 'type' ]
			) {
				// just clean the cache when new plugin version is installed
				delete_transient( $this->cache_key );
			}

		}


	}

	new chmContacts_UpdateChecker();

}
