<?php
namespace chmContacts;

class Database {
	private static $wpdb = null;
	private static $initialized = false;

	private static $comparators = [
		"LIKE",
		"LIKE%",
		"NOT LIKE",
		"NOT LIKE%",
		"=",
		"!=",
		">",
		"<",
		">=",
		"<=",
		"REGEXP",
		"NOT REGEXP",
		// "IN",
		// "NOT IN",
		// "BETWEEN",
		// "NOT BETWEEN"
	];

	private static $connectors = [
		"AND",
		"OR",
	];

	private static $sortDirections = [
		"ASC",
		"DESC"
	];

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			global $wpdb;
			self::$wpdb = $wpdb;
		}

	}

	public static function validateComparator($comparator) {
		self::init();
		$comparator = strtoupper(trim($comparator));
		if (!in_array($comparator, self::$comparators)) {
			$comparator = '=';
		}
		return $comparator;
	}

	public static function validateConnector($connector) {
		self::init();
		$connector = strtoupper(trim($connector));
		if (!in_array($connector, self::$connectors)) {
			$connector = 'AND';
		}
		return $connector;
	}

	private static function query($method, $table, $data, $format = null, $where = []) {
		if (empty($format)) {
			$format = [];
			foreach ($data as $key => $value) {
				array_push($format, '%s');
			}
		}

		$table = Config::table($table);

		if ($method == 'update') {
			self::$wpdb->$method(
				$table,
				$data,
				$where,
				$format
			);
		} else {
			self::$wpdb->$method(
				$table,
				$data,
				$format
			);
		}
		return true;
	}

	public static function where($where, $connector = 'AND') {
		self::init();
		$connector = self::validateConnector($connector);
		$whereset = [($connector == 'AND') ? 'TRUE' : 'FALSE'];
		if (!empty($where)) {
			if (Helper::isAssoc($where)) {
				foreach ($where as $col => $val) {
					array_push($whereset, '`'.self::$wpdb->_escape($col).'`="'.self::$wpdb->_escape($val).'"');
				}
			} else {
				for ($i = 0; $i < count($where); $i++) {
					$column = self::$wpdb->_escape($where[$i][0]);
					$comparator = self::validateComparator($where[$i][1]);
					$value = self::$wpdb->_escape($where[$i][2]);
					if (strpos($comparator, '%') !== false) {
						$comparator = str_replace('%', '', $comparator);
						$value = '%'.$value.'%';
					}

					array_push($whereset, '`'.$column.'` '.$comparator.' "'.$value.'"');
				}
			}

		}
		// return implode(' '.$connector.' ', $whereset);
		return '('.implode(' '.$connector.' ', $whereset).')';
	}

	public static function escape($value) {
		self::init();
		return self::$wpdb->_escape($value);
	}

	public static function get($table, $where = []) {
		self::init();
		$row = self::$wpdb->get_row('SELECT * FROM `'.Config::table($table).'` WHERE '.self::where($where).' LIMIT 1;', ARRAY_A);
		return empty($row) ? [] : $row;
	}

	public static function getAll($table, $where = []) {
		self::init();
		$result = self::$wpdb->get_results('SELECT * FROM `'.Config::table($table).'` WHERE '.self::where($where).';', ARRAY_A);
		return empty($result) ? [] : $result;
	}

	public static function getRaw($query) {
		self::init();
		$result = self::$wpdb->get_results($query, ARRAY_A);
		return empty($result) ? [] : $result;
	}

	public static function insert($table, $data, $format = null) {
		self::init();
		return self::query('insert', $table, $data, $format);
	}

	public static function replace($table, $data, $format = null) {
		self::init();
		return self::query('replace', $table, $data, $format);

	}

	public static function update($table, $data, $where, $format = null) {
		self::init();
		return self::query('update', $table, $data, $format, $where);
	}

	public static function delete($table, $where) {
		self::init();
		self::$wpdb->query('DELETE FROM `'.Config::table($table).'` WHERE '.self::where($where).';');
		return true;
	}

}
