(function($) {
	const __NAMESPACE__ = 'chmContacts';

	var PARAMS, inputs;

	inputs = [];

	function updateModified(data) {
		data.$element[data.isModified ? 'addClass' : 'removeClass']('chm_settings_input_modified');
		data.$element[data.isDefault ? 'addClass' : 'removeClass']('chm_settings_input_default');
	}

	function setDefault(data) {
		data.value = data.default;
		data.isDefault = true;
		data.isModified = true;
		updateModified(data);
	}

	function request(data, onSuccess, onError) {
		var postData;
		postData = {
			action: PARAMS.ajaxAction,
			data: encodeURIComponent(JSON.stringify(data))
		};
		$('body').addClass('chm_loading');
		$.post({
			url: PARAMS.ajaxUrl,
			data: postData,
			success: function() {
				if (onSuccess) {
					onSuccess.call();
				}
			},
			error: function() {
				if (onError) {
					onError.call();
				}
			},
			complete: function() {
				$('body').removeClass('chm_loading');
			},
			dataType: 'json'
		});
	};

	$(document).ready(function() {
		PARAMS = window[__NAMESPACE__+'_params'];

		$('.chm_settings_input[data-namespace="'+__NAMESPACE__+'"]').each(function() {
			var $this, $input, $useDefault, data, valueData;

			$this = $(this);


			valueData = {
				value: JSON.parse(atob($(this).attr('data-value'))),
				default: JSON.parse(atob($(this).attr('data-default')))
			};

			data = {
				$element: $this,
				type: $(this).attr('data-type'),
				path: $(this).attr('data-path'),
				value: valueData.value.value,
				prevValue: valueData.value.value,
				default: valueData.default.value,
				isDefault: valueData.default.isDefault,
				isModified: false
			};

			$useDefault = $this.find('.chm_settings_default');

			if (data.type == 'bool') {
				$input = $this.find('input[type="checkbox"]');
				$input.prop('checked', data.value).on('change', function() {
					data.value = $input.prop('checked');
					data.isModified = (data.prevValue != data.value);
					data.isDefault = false;
					updateModified(data);
				});
				$useDefault.on('click', function() {
					$input.prop('checked', data.default);
					setDefault(data);
				});
			} else if (data.type == 'text') {
				$input = $this.find('input[type="text"]');
				$input.val(data.value).on('input change', function() {
					data.value = $input.val();
					data.isModified = (data.prevValue != data.value);
					data.isDefault = false;
					updateModified(data);
				});
				$useDefault.on('click', function() {
					$input.val(data.default);
					setDefault(data);
				});
			} else if (data.type == 'int') {
				$input = $this.find('input[type="text"]');
				$input.val(data.value).on('input change', function() {
					var val;
					val = $input.val();
					data.value = parseInt(val, 10);
					if (String(data.value) != String(val)) {
						$input.val(data.value);
					}
					data.isModified = (data.prevValue != data.value);
					data.isDefault = false;
					updateModified(data);
				});
				$useDefault.on('click', function() {
					$input.val(data.default);
					setDefault(data);
				});
			} else if (data.type == 'list') {
				$input = $this.find('textarea');
				$input.val(data.value.join('\n')).on('input change', function() {
					var v, value, finalValue, rawValue;
					rawValue = $input.val().split('\n');
					finalValue = [];
					for (v = 0; v < rawValue.length; v++) {
						value = rawValue[v].trim();
						if (value != '') {
							finalValue.push(value);
						}
					}
					data.value = finalValue;
					data.isModified = (data.prevValue.join('\n') != data.value.join('\n'));
					data.isDefault = false;
					updateModified(data);
				});
				$useDefault.on('click', function() {
					$input.val(data.default.join('\n'));
					setDefault(data);
				});
			}

			updateModified(data);

			inputs.push({
				data: data
			});
		});

		$(document).on('click', '.chm_settings_save[data-namespace="'+__NAMESPACE__+'"]', function() {
			var i, values, data;
			values = {};
			for (i = 0; i < inputs.length; i++) {
				data = inputs[i].data;
				values[data.path] = {
					type: data.type,
					default: data.isDefault,
					value: data.value
				};
			}
			request(
				{
					action: __NAMESPACE__+'__saveSettings',
					data: {
						settings: values
					}
				},
				function() {
					var i, data;
					for (i = 0; i < inputs.length; i++) {
						data = inputs[i].data;
						data.isModified = false;
						updateModified(data);
					}
				},
				function() {
					alert('SAVE FAILED');
				}
			);
		});

		$(document).on('click', '.chm_settings_dismiss[data-namespace="'+__NAMESPACE__+'"]', function() {
			if (confirm('Dismiss all changes?')) {
				location.reload(true);
			}
		});
	});


})(jQuery);