<?php
namespace chmContacts;

class Config {
	private static $_config = [];
	private static $_config_CACHE = [];
	private static $initialized = false;

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
		}
	}

	public static function create() {
		self::init();
	}

	private static function optionKey($configName, $path) {
		$prefix = __NAMESPACE__.'_Config_'.$configName.'_';
		$optionKey = $prefix.$path;
		if (strlen($optionKey) > 150) {
			$optionKey = $prefix.md5($path);
		}
		return $optionKey;
	}

	private static function renderField($field, $configName, $path, $key = '', $originalPath = '') {

		$value = self::get($path, $configName);

		$default = (empty($key)) ? self::$_config[$configName]['MODIFY'][$path]['default'] : self::$_config[$configName]['MODIFY'][$originalPath]['default'][$key];

		return Template::render(
			'settings/types/'.$field['type'],
			[
				'namespace' => __NAMESPACE__,
				'type' => $field['type'],
				'label' => $field['label'],
				'additionalLabel' => $key,
				'name' => $name,
				'path' => $path,
				'id' => md5($path),
				'value' => base64_encode(json_encode(['value' => $value])),
				'default' => base64_encode(json_encode([
					'isDefault' => (get_option(self::optionKey($configName, $path), null) === NULL),
					'value' => $default
				])),
			],
			true
		);		
	}

	private static function override($configName, $path, $type) {
		$wpOption = get_option(self::optionKey($configName, $path), null);
		if ($wpOption !== NULL) {
			if ($type == 'bool') {
				$wpOption = ($wpOption == 'true');
			}
			Helper::setValueByPath(self::$_config[$configName], $path, $wpOption);
		}
	}

	public static function load($configName) {
		$configName = basename($configName);

		if (!array_key_exists($configName, self::$_config)) {
			$configFile = __DIR__.'/../_config/'.$configName.'.php';
			if (file_exists($configFile)) {
				self::$_config[$configName] = include($configFile);
			} else {
				self::$_config[$configName] = [];
			}
			self::$_config_CACHE[$configName] = [];

			//check for modifications
			if (array_key_exists('MODIFY', self::$_config[$configName])) {
				foreach (self::$_config[$configName]['MODIFY'] as $path => $field) {
					if (substr($path, -1) == '*') {
						$rootPath = substr($path, 0, -2);
						self::$_config[$configName]['MODIFY'][$path]['default'] = [];
						foreach (Helper::getValueByPath(self::$_config[$configName], $rootPath) as $subPath => $defaultValue) {
							self::$_config[$configName]['MODIFY'][$path]['default'][$subPath] = $defaultValue;
							self::override($configName, $rootPath.'/'.$subPath, $field['type']);
						}
					} else {
						$defaultValue = Helper::getValueByPath(self::$_config[$configName], $path);
						self::$_config[$configName]['MODIFY'][$path]['default'] = $defaultValue;
						self::override($configName, $path, $field['type']);
					}
				}
			}
		}

		return self::$_config[$configName];
	}

	public static function get($path, $configName = 'settings') {
		self::init();
		self::load($configName);
		// print_r(self::$_config[$configName]);
		// die;
		if (!array_key_exists($path, self::$_config_CACHE[$configName])) {
			self::$_config_CACHE[$configName][$path] = Helper::getValueByPath(self::$_config[$configName], $path);
		}
		return self::$_config_CACHE[$configName][$path];
	}

	public static function getSettings($configName = 'settings') {
		self::init();
		self::load($configName);
		if (array_key_exists('MODIFY', self::$_config[$configName])) {
			$fields = [];
			foreach(self::$_config[$configName]['MODIFY'] as $path => $field) {
				if (substr($path, -1) == '*') {
					$path = substr($path, 0, -2);
					foreach (self::get($path, $configName) as $key => $value) {
						array_push(
							$fields,
							self::renderField($field, $configName, $path.'/'.$key, $key, $path.'/*')
						);
					}
				} else {
					array_push(
						$fields,
						self::renderField($field, $configName, $path)
					);
				}
			}
		}
		return implode('', $fields);
	}

	public static function saveSettings($settings, $configName = 'settings') {
		foreach ($settings as $path => $setting) {
			if ($setting['default']) {
				delete_option(self::optionKey($configName, $path));
			} else {
				$value = $setting['value'];
				$type = $setting['type'];
				if ($type == 'bool') {
					$value = $value ? 'true' : 'false';
				}
				update_option(self::optionKey($configName, $path), $value, false);
			}
		}
		return true;
	}

	public static function table($tableName) {
		self::init();
		global $wpdb;

		if (array_key_exists($tableName, self::$_config['settings']['tables'])) {
			return strtolower($wpdb->prefix.self::$_config['settings']['tables'][$tableName]);
		} else {
			$table = $wpdb->_escape($tableName);
			if (substr($table, 0,strlen($wpdb->prefix)) != $wpdb->prefix) {
				$table = $wpdb->prefix.$table;
			}
			return $table;
		}
	}
}
