<?php
namespace chmContacts;

class Helper {

	private static $initialized = false;
	private static $seed = 0;

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
		}
	}

	public static function id() {
		self::init();
		self::$seed++;
		return md5(microtime().rand(1111111,9999999).self::$seed);
	}

	//check if array is assoc
	public static function isAssoc($array) {
		self::init();
		if (!is_array($array)) {
			return false;
		}
		if (array() === $array) {
			return false;
		}
		return (array_keys($array) !== range(0, count($array) - 1));
	}

	//read value from multi dimensional associative array by given path
	public static function getValueByPath($assoc, $path) {
		if (array_key_exists($path, $assoc)) {
			return $assoc[$path];
		} else {
			$segments = explode('/', $path);
			$obj = $assoc;
			$segment = true;

			while ($segment !== NULL) {
				$segment = array_shift($segments);
				if ($segment !== NULL) {
					if (array_key_exists($segment, $obj)) {
						$obj = $obj[$segment];
					} else {
						$obj = NULL;
						break;
					}
				}
			}
			return $obj;
		}
	}

	//set given value in multi dimensional associative array by given path
	public static function setValueByPath(&$assoc, $path, $value) {
		if (array_key_exists($path, $assoc)) {
			$assoc[$path] = $value;
			return true;
		} else {
			$segments = explode('/', $path);

			if (count($segments) > 1) {
				$obj = &$assoc;
				$exists = true;
				for ($i = 0; $i < (count($segments)-1); $i++) {
					if (array_key_exists($segments[$i], $obj)) {
						$obj = &$obj[$segments[$i]];
					} else {
						$exists = false;
					}
				}
				if ($exists) {
					$lastSegment = $segments[count($segments)-1];
					if (array_key_exists($lastSegment, $obj)) {
						$obj[$lastSegment] = $value;
						return true;
					}
				}
			}
		}
		return false;
	}

	//normalize realtive path component
	public static function normalizeRelativePath($path, $leadingSlash = false, $trailingSlash = false) {
		if (!$leadingSlash && (substr($path, 0, 1) == '/')) {
			$path = substr($path, 1);
		}
		if (!$trailingSlash && (substr($path, -1) == '/')) {
			$path = substr($path, 0, -1);
		}
		return $path;
	}

	//replace all markers {{marker}} in $text with the corresponding values from $vars
	public static function replaceMarkers($text, $vars) {
		self::init();
		if (self::isAssoc($vars)) {
			foreach ($vars as $key => $value) {
				$text = str_replace('{{'.$key.'}}', $value, $text);
			}
		}
		return $text;
	}

	/*** load JS and CSS ***/
	public static function loadScripts($view ) {
		self::init();

		if (in_array($view, ['frontend','backend'])) {

			$cnt = 1;
			foreach(glob(Config::get('css_dir').$view.'/'.'*.css') as $cssFile) {
				$styleID = 'chmContacts_'.$view.'_CSS_'.$cnt;
				wp_register_style($styleID, Config::get('base_url').'/'.Config::get('css_url_part').$view.'/'.basename($cssFile), false, time());
			 	wp_enqueue_style($styleID);
				$cnt++;
			}

			$cnt = 1;
			foreach(glob(Config::get('js_dir').$view.'/'.'*.js') as $jsFile) {
				$scriptID = 'chmContacts_'.$view.'_JS_'.$cnt;
				wp_enqueue_script($scriptID, Config::get('base_url').'/'.Config::get('js_url_part').$view.'/'.basename($jsFile), ['jquery'], time());

				$cnt++;
			}

			$params = [
				'ajaxUrl' => admin_url('admin-ajax.php', '//'),
				'ajaxAction' => \chmContacts\Config::get('ajax_action'),
				'isAdmin' => Access::check()
			];
			wp_localize_script($scriptID, 'chmContacts_params', $params);

		}
	}

}
