<?php
namespace chmContacts;

class Ajax {
	private static $initialized = false;
	private static $actions = [
		'admin' => [],
		'user' => []
	];

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			//ajax actions that can be called without authentication and privileges
			self::$actions['user'] = [
				'search' => function($input) {
					if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_SEARCH')) {
						if ($input['mode'] == 'contacts') {
							return Storage::searchContacts($input['search'], $input['offset'], Config::get('contact_load_limit'));
						} else {
							return Storage::searchContactsByItem($input['mode'], $input['id'], $input['offset'], Config::get('contact_load_limit'));
						}
					} else {
						return [
							'contacts' => [],
							'more' => false,
							'offset' => 0
						];
					}
				},
				'welcomeList' => function($input) {
					if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_WELCOME')) {
						return Storage::getNewContacts(100);
					} else {
						return [
							'gender' => 'none',
							'list' => []
						];
					}
				},
				'welcomeItem' => function($input) {
					if (Config::get('ENABLE_SHORTCODES') && Config::get('ENABLE_WELCOME')) {
						return Storage::getNewContacts(2);
					} else {
						return [
							'gender' => 'none',
							'list' => []
						];
					}
				}
			];
			//ajax actions that require authentication and access capability
			self::$actions['admin'] = [
				'list' => function($input) {
					return Storage::listContacts($input['offset'], Config::get('contact_load_limit'), false);
				},
				'getImageUrls' => function($input) {
					return Storage::getImageUrls($input['contactID']);
				},
				'listUnits' => function($input) {
					return [
						'units' => Storage::getList('units')
					];
				},
				'updateUnits' => function($input) {
					return [
						'done' => Storage::updateUnits($input['units'])
					];
				},
				'save' => function($input) {
					return Storage::saveContact($input);
				},
				'delete' => function($input) {
					return Storage::deleteContact($input['contactID'], true);
				},
				'items' => function($input) {
					$items = [];
					foreach (Config::get('mappings') as $itemTable => $settings) {
						$items[$itemTable] = Storage::getList($itemTable);
					}
					return ['items' => $items];
				},
				'addItem' => function($input) {
					return Storage::addItem($input);
				},
			
				'chmContacts__saveSettings' => function($input) {
					//admin access only
					if (current_user_can('manage_options')) {
						return Config::saveSettings($input['data']['settings']);
					} else {
						return false;
					}
				}
			];
		}
	}

	public static function request($isAuthenticated) {
		self::init();

		$success = false;
		$response = [];

		$data = @$_GET['data'];
		if (empty($data)) {
			$data = @$_POST['data'];
		}
		$data = stripslashes($data);

		$input = json_decode(rawurldecode($data), true);

		if (array_key_exists($input['action'], self::$actions['user'])) {
			$response = self::$actions['user'][$input['action']]($input);
		} else if ($isAuthenticated && Access::check() && array_key_exists($input['action'], self::$actions['admin'])) {
			$response = self::$actions['admin'][$input['action']]($input);
		}

		$success = ($response !== false);

		header('Content-type:application/json; charset=utf-8');
		echo json_encode([
			'success' => $success,
			'response' => $response
		]);
		die;
	}
}
