<?php
if ( ! defined( 'ABSPATH' ) ) exit;

global $wpdb;
$charset_collate = $wpdb->get_charset_collate();

return [
	"CREATE TABLE ".\chmContacts\Config::table('contacts')." (
		id varchar(32) NOT NULL,
		editable tinyint(1) DEFAULT '0' NOT NULL,
		sync_exclude tinyint(1) DEFAULT '0' NOT NULL,
		contact_number varchar(255) DEFAULT '' NOT NULL,
		salutation varchar(255) DEFAULT '' NOT NULL,
		title varchar(255) DEFAULT '' NOT NULL,
		name_prefix varchar(255) DEFAULT '' NOT NULL,
		first_name varchar(255) DEFAULT '' NOT NULL,
		last_name varchar(255) DEFAULT '' NOT NULL,
		status varchar(255) DEFAULT '' NOT NULL,
		email varchar(255) DEFAULT '' NOT NULL,
		image_post_id bigint(20) DEFAULT '0' NOT NULL,
		show_image tinyint(1) DEFAULT '0' NOT NULL,
		phone_internal varchar(255) DEFAULT '' NOT NULL,
		phone_dect varchar(255) DEFAULT '' NOT NULL,
		start_date DATE DEFAULT NULL,
		room varchar(255) DEFAULT '' NOT NULL,
		fax varchar(255) DEFAULT '' NOT NULL,
		PRIMARY KEY  (id),
		KEY contact_number (contact_number),
		KEY name_prefix (name_prefix),
		KEY first_name (first_name),
		KEY last_name (last_name),
		KEY email (email),
		KEY phone_internal (phone_internal),
		KEY phone_dect (phone_dect)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('companies')." (
		id varchar(32) NOT NULL,
		name varchar(255) NOT NULL,
		PRIMARY KEY  (id),
		KEY name (name)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('units')." (
		id varchar(32) NOT NULL,
		name varchar(255) NOT NULL,
		phone_internal varchar(255) DEFAULT '' NOT NULL,
		PRIMARY KEY  (id),
		KEY name (name)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('jobs')." (
		id varchar(32) NOT NULL,
		name varchar(255) NOT NULL,
		PRIMARY KEY  (id),
		KEY name (name)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('representations')." (
		id varchar(32) NOT NULL,
		name varchar(255) NOT NULL,
		PRIMARY KEY  (id),
		KEY name (name)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('languages')." (
		id varchar(32) NOT NULL,
		name varchar(255) NOT NULL,
		PRIMARY KEY  (id),
		KEY name (name)
	) $charset_collate;",

	"CREATE TABLE ".\chmContacts\Config::table('map_items')." (
		id varchar(32) NOT NULL,
		item_table varchar(255) NOT NULL, 
		item_id varchar(32) NOT NULL,
		contact_id varchar(32) NOT NULL,
		PRIMARY KEY  (id),
		KEY item_table (item_table),
		KEY item_id (item_id),
		KEY contact_id (contact_id)
	) $charset_collate;",
];
