<?php
namespace chmContacts;

class Access {


	private static $initialized = false;

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
		}
	}


	/*** check access with optional full stop on deny ***/
	public static function check($stopOnDeny = false) {
		self::init();

		$access = false;

		$object = Config::get('accessAPI')['controller'];
		$method = Config::get('accessAPI')['method'];
		$module = __NAMESPACE__;

		if (method_exists($object, $method)) {
			$access = $object::$method($module, $stopOnDeny);
		} else {
			$access = current_user_can('manage_options');
		}

		if (!$access && $stopOnDeny) {
			echo 'ACCESS DENIED!';
			die;
		}

		return $access;
	}
}
