<?php
namespace chmContacts;

class Template {

	private static $initialized = false;
	private static $template_dir = '';

	private static function init() {
		if (!self::$initialized) {
			self::$initialized = true;
			self::$template_dir = [
				'core' => __DIR__.'/../private/core/templates',
				'plugin' => __DIR__.'/../res/templates'
			];
		}
	}


	/*** load given template and render by replacing optional markers ***/
	public static function render($templateName, $markers = [], $core = false) {
		self::init();

		if (strtolower(substr($templateName, -5)) != '.html') {
			$templateName .= '.html';
		}
		if (strtolower(substr($templateName, 0, 1)) == '/') {
			$templateName = substr($templateName, 1);
		}

		$templateFile = self::$template_dir[$core ? 'core' : 'plugin'].'/'.$templateName;

		$template = file_exists($templateFile) ? file_get_contents($templateFile) : '';

		return Helper::replaceMarkers($template, $markers);
	}

}
