var chmContacts_ControlPanel = (function() {
	var $ = jQuery;

	return function($container) {
		var $element, actions, sortCol, sortAsc;

		if ($container.attr('data-edit') == 'units') {
			return chmContacts_UnitsEditor($container);
		}

		$(window).on('resize', function() {
			resizeEditor();
		});

		sortCol = 3;
		sortAsc = true;

		$element = {
			tab: {
				contacts: $container.find('[data-results="contacts"]')
			}
		};

		function resetActions() {
			actions = {
				add: function() {
					var contact;
					contact = {
						id: '',
						editable: true,
						exlude_sync: false,
						image: false
					};
					editContact(contact);
				},
				save: function() {},
				delete: function() {},
				cancel: function() {},
				uploadImage: function() {},
				deleteImage: function() {},
				resetImage: function() {},
				sync_exclude: function() {}
			};
		}
		resetActions();

		$container.find('[data-change-action]').on('change', function() {
			actions[$(this).attr('data-change-action')].call();
		});

		$container.find('[data-button-action]').on('click', function() {
			actions[$(this).attr('data-button-action')].call();
		});

		$container.find('[data-checkbox-action]').on('change', function() {
			actions[$(this).attr('data-checkbox-action')].call(this);
		});

		

		$container.find('.chmContacts-search-input-text').on('input', function() {
			filterTable($(this).val());
		}).on('keydown', function(event) {
			if (event.which == 27) {
				$(this).val('').trigger('input');
			}
		}).focus();

		
		(function($tabs) {
			var storedMode, $storedTab;
			$tabs.on('click', function() {
				var $tab, mode;
				$tab = $(this);
				mode = $tab.attr('data-mode');
				$container.find('.chmContacts-search-tabs-tab').removeClass('active');
				$tab.addClass('active');
				$element.tab.contacts.attr('data-mode', mode);
				$container.find('.chmContacts-search-input-text').focus();
				localStorage.setItem('chmContacts-ControlPanel-mode', mode);
			});	
			storedMode = localStorage.getItem('chmContacts-ControlPanel-mode');
			$tabs.first().trigger('click');
			if (storedMode) {
				$tabs.filter('[data-mode="'+storedMode+'"]').first().trigger('click');
			}

		})($container.find('.chmContacts-search-tabs-tab'));


		function filterTable(inputText) {
			var keywords;
			keywords = String(inputText).trim().toLowerCase().split(' ');
			if ((keywords.length > 0) && (keywords[0] != '')) {
				$container.find('table tbody tr').each(function() {
					var i, $tr, text;
					$tr = $(this);
					text = String($tr.text()).toLowerCase();
					for (i = 0; i < keywords.length; i++) {
						if (text.indexOf(keywords[i]) < 0) {
							$tr.hide();
							return;
						}
					}
					$tr.show();
				});
			} else {
				$element.tab.contacts.find('table tbody tr').show();
			}
		}

		function renderContact(contact) {
			var $tr;
			$tr = chmContacts_Backend.render(contact);
			$tr.on('click', function() {
				editContact(contact, $tr);
			});
			return $tr;
		}

		function editContact(contact, $tr) {
			if (contact.image !== null) {
				renderEditContact(contact, $tr);
			} else {
				chmContacts.request(
					{
						action: 'getImageUrls',
						contactID: contact.id
					},
					function(resp) {
						if (resp.success && resp.response) {
							$.each(resp.response, function(key, value) {
								contact[key] = value;
							});
						}
						renderEditContact(contact, $tr);
					}
				);

			}
		}

		function renderEditContact(contact, $tr) {
			var $form, $image, changed, imageChanged, $button;

			$form = chmContacts_Backend.editForm(contact);

			$image = $form.find('.contact-image');

			$image.attr('data-src', $image.attr('src'));

			$button = {
				deleteImage: $container.find('[data-button-action="deleteImage"]').hide(),
				resetImage: $container.find('[data-button-action="resetImage"]').hide()
			};

			changed = false;
			imageChanged = false;

			resetActions();


			if (contact.editable || contact.sync_exclude) {
				$form.find('[data-add-item]').show().on('click', function() {
					var name;
					name = prompt('Bitte die Bezeichnung des neuen Eintrags eingeben:');

					if (name && (String(name).trim() != '')) {
						chmContacts.request(
							{
								action: 'addItem',
								item: $(this).attr('data-add-item'),
								name: name,
								image: {
									changed: imageChanged,
									src: imageChanged ? $image.attr('src') : ''
								}
							},
							function(resp) {
								if (resp.success) {
									if (resp.response.added) {
										updateItems($form, contact);
									} else {
										alert(resp.response.error);
									}
								} else {
									alert('Fehler beim Hinzufügen.');
								}
							}
						);
					}
				});

				actions.save = function() {
					var items, updateItems;

					$form.find('[data-field]').each(function() {
						var $input;
						$input = $(this);
						contact[$input.attr('data-field')] = $input.val();
					});

					items = {};
					updateItems = {};
					$form.find('select[data-item]').each(function() {
						var $select, selected, updated;
						$select = $(this);
						selected = [];
						updated = [];
						$select.find('option:selected').each(function() {
							var $option;
							$option = $(this);
							selected.push($option.attr('data-id'));
							updated.push({
								id: $option.attr('data-id'),
								name: $option.text()
							});
						});
						items[$select.attr('data-item')] = selected;
						updateItems[$select.attr('data-item')] = updated;
					});

					chmContacts.request(
						{
							action: 'save',
							contact: contact,
							image: {
								changed: imageChanged,
								src: imageChanged ? $image.attr('src') : ''
							},
							items: items
						},
						function(resp) {
							var item;
							if (resp.success) {
								if (resp.response.saved) {
									if (!$tr) {
										contact.id = resp.response.contactID;
										$tr = renderContact(contact);
										$element.tbody.append($tr);
									}
									$tr.find('[data-field]').each(function() {
										var $td;
										$td = $(this);
										$td.text(contact[$td.attr('data-field')]);
									});
									$tr.find('[data-field="last_name"]').text(chmContacts_Backend.getLastName(contact));
									contact.image = $image.attr('src');
									if (contact.image == '') {
										contact.image = false;
									}
									for (item in updateItems) {
										contact[item] = updateItems[item];
									}
									hideEditor();
									$tr.get(0).scrollIntoView(true);
								} else {
									alert(resp.response.error);
								}
							} else {
								alert('Fehler beim Speichern, die Änderungen wurden evtl. nicht übernommen.');
							}
						}
					);
				};

				actions.cancel = function() {
					if (!changed && !imageChanged) {
						hideEditor();
					} else {
						if (confirm('Bearbeiten abbrechen und Änderungen verwerfen?')) {
							hideEditor();
						}
					}
				};

				$form.find('input, select').on('input change', function() {
					changed = true;
				});

			}


			if (contact.editable) {
				if (contact.image !== false) {
					$button.deleteImage.show();
				}

				$container.find('[data-button-action="save"], [data-button-action="delete"], .image-upload').show();

				actions.delete = function() {
					if (confirm('Soll der Kontakt unwiderruflich gelöscht werden?')) {
						chmContacts.request(
							{
								action: 'delete',
								contactID: contact.id
							},
							function(resp) {
								if (resp.success) {
									$tr.remove();
									hideEditor();
								} else {
									alert('Dieser Kontakt kann nicht gelöscht werden.');
								}
							}
						);
					}
				};

				actions.deleteImage = function() {
					if (!imageChanged) {
						imageChanged = true;
						$image.attr('src', '');
						$button.deleteImage.hide();
						$button.resetImage.show();
					}
				};

				actions.resetImage =function() {
					if (imageChanged) {
						imageChanged = false;
						$image.attr('src', $image.attr('data-src'));
						$button.resetImage.hide();
						if (contact.image) {
							$button.deleteImage.show();
						}
					}
				};

				actions.uploadImage = function() {
					var $file, file, reader;
					$file = $container.find('[id="imageUpload"]');
					file = $file.get(0).files[0];
					if (file.type.match(/image.*/)) {
						imageChanged = true;
						$button.deleteImage.hide();
						$button.resetImage.show();
						reader = new FileReader();
						reader.onload = function(e) {
							$image.attr('src', reader.result);
						}
						reader.readAsDataURL(file);
					} else {
						alert('Die gewählte Datei ist kein Bild.')
					}
				};

				$container.find('.chmContacts-sync-exclude').hide();
				$container.find('[data-button-action="cancel"]').text('Abbrechen');
			} else {
			
				actions.cancel=  function() {
					hideEditor();
				};

				actions.sync_exclude = function() {
					sync_exclude = $(this).prop('checked');

					if (!sync_exclude && changed && !confirm('Beim Umschalten gehen die aktuellen Änderungen verloren.\n\nFortfahren?')) {
						return;
					}

					chmContacts.request(
						{
							action: 'save',
							attribute: 'sync_exclude',
							contact: contact.id,
							sync_exclude: sync_exclude
						},
						function(resp) {
							if (resp.success) {
								if (resp.response.saved) {
									$tr.toggleClass('sync-exclude', sync_exclude).toggleClass('not-editable', !sync_exclude);
									contact.sync_exclude = sync_exclude;
									hideEditor();
									editContact(contact, $tr);
								} else {
									alert(resp.response.error);
								}
							} else {
								alert('Fehler beim Speichern, die Änderungen wurden evtl. nicht übernommen.');
							}
						}
					);
				};


				$container.find('[id="chmContacts_sync_exclude"]').prop('checked', contact.sync_exclude);
				$container.find('.chmContacts-sync-exclude').show();


				if (contact.sync_exclude) {
					$form.find('input, select').prop('disabled', false);
					$form.find('input[data-field="contact_number"]').prop('disabled', true);
					$container.find('[data-button-action="save"]').show();

					$container.find('[data-button-action="delete"], .image-upload').hide();

					$container.find('[data-button-action="cancel"]').text('Abbrechen');

				} else {
					$form.find('[data-add-item]').hide();
					$container.find('[data-button-action="save"], [data-button-action="delete"], .image-upload').hide();

					$form.find('input, select').prop('disabled', true);
					$container.find('[data-button-action="cancel"]').text('Zurück');
				}
			}

			$container.find('.chmContacts-list-buttons, .chmContacts-search-input, .chmContacts-search-tabs, .chmContacts-search-results').hide();
			$container.find('.chmContacts-editor-buttons').show()

			$container.find('.chmContacts-editor').show().empty().append(
				$form
			);

			resizeEditor();

			updateItems($form, contact);
		}

		function updateItems($form, contact) {
			chmContacts.request(
				{
					action: 'items'
				},
				function(resp) {
					var itemName, items, i, $select, $option, selected;
					if (resp.success) {
						for (itemName in resp.response.items) {
							items = resp.response.items[itemName];
							$select = $form.find('[data-item="'+itemName+'"]').empty();
							selected = [];
							if (contact[itemName]) {
								for (i = 0; i < contact[itemName].length; i++) {
									selected.push(contact[itemName][i].id);
								}
							}
							for (i = 0; i < items.length; i++) {
								$option = $('<option>').text(items[i].name).attr({
									'data-id': items[i].id,
									title: items[i].name
								});
								if (selected.indexOf(items[i].id) >= 0) {
									$option.attr('selected', 'selected');
								}
								$select.append(
									$option
								);
							}
						}
					}
				}
			);
		}

		function resizeEditor() {
			$container.find('.chmContacts-editor').css({
				top: $container.find('.chmContacts-editor-buttons').outerHeight() + $container.find('.chmContacts-search-title').outerHeight()
			});
		}

		function hideEditor() {
			$container.find('.chmContacts-editor-buttons, .chmContacts-editor').hide();
			$container.find('.chmContacts-list-buttons, .chmContacts-search-input, .chmContacts-search-tabs, .chmContacts-search-results').show();
			$container.find('.chmContacts-search-input-text').focus();
			resetActions();
		}

		function sortTable() {
			var $tbody, rows, r;
			if (sortCol >= 0) {
				rows = [];
				$tbody = $element.table.find('tbody');
				$tbody.find('tr').each(function() {
					rows.push($(this));
				});
				rows.sort(function($rowA, $rowB) {
					var ret;
					try {
						ret = ($rowA.find('td').eq(sortCol).text() > $rowB.find('td').eq(sortCol).text()) ? 1 : -1;
					} catch(e) {
						ret = 0;
					}
					return sortAsc ? ret : -ret;
				});
				for (r = 0; r < rows.length; r++) {
					$tbody.append(rows[r]);
				}
				$element.table.find('thead th').removeClass('sorted sorted-asc sorted-desc').eq(sortCol).addClass('sorted '+(sortAsc ? 'sorted-asc' : 'sorted-desc'));
			}
		}

		function loadMore(offset, loaded) {

			if (!offset) {
				offset = 0;
			}

			chmContacts.request(
				{
					action: 'list',
					offset: offset
				},
				function(resp) {
					var i;
					for (i = 0; i < resp.response.contacts.length; i++) {
						$element.tbody.append(
							renderContact(resp.response.contacts[i])
						);
					}
					if (resp.response.more) {
						loadMore(resp.response.offset, $element.tbody.children().length);
					} else {
						$element.table = $('<table>').append(
							chmContacts_Backend.renderHeader(),
							$element.tbody
						);
						$element.table.find('thead th').on('click', function() {
							var $th;
							$th = $(this);
							if (sortCol != $th.index()) {
								sortAsc = true;
								sortCol = $th.index();
							} else {
								sortAsc = !sortAsc;
							}
							sortTable();
						});
						$element.tab.contacts.append($element.table);
						sortTable();
					}
				},
				`<span class="loading-status-text">Kontakte laden...</span><span class="loading-status-number">${loaded}</span>`
			);


		}

		$element.tbody = $('<tbody>');
		loadMore(0, 0);

	};

})();