chmContacts = (function() {
	var that, $, runningRequests;

	$ = jQuery;
	runningRequests = 0;

	$(document).ready(function() {

		// console.log(chmContacts_params);


		$('.chmContacts-search').each(function() {
			chmContacts_Search($(this));
		});

		if ($('.chmContacts_Welcome').length > 0) {
			that.request(
				{
					action:'welcomeItem'
				},
				function(resp) {
					var html;
					if (resp.success && resp.response.list) {
						if (resp.response.list.length > 0) {
							html = resp.response.list[0]; //.join('');
							$('.chmContacts_Welcome').each(function() {
								var $title;
								$title = $(this).find('.title');
								$title.html(atob($title.attr('data-title-'+resp.response.gender)));
								$(this).find('.list').slideUp(function() {
									$(this).html(html).removeClass('loading').slideDown();
								});
								if (resp.response.list.length > 1) {
									$(this).find('.showMore').slideDown();
								}
							});
						} else {
							$('.chmContacts_Welcome').each(function() {
								var $title;
								$title = $(this).find('.title');
								$title.html(atob($title.attr('data-title-none')));
								$(this).find('.list').slideUp();
							});
						}
						// $element.results.append(resp.response.list.join(''));
					} else {
						$('.chmContacts_Welcome .list').html('Fehler beim Laden.'),removeClass('loading');
					}
				}
			);
		}

		$('[data-action="welcomeShowAll"]').on('click', function() {
			var $element;

			$element = {
				overlay: $('.chmContactsWelcome-overlay').first(),
				list: $('.chmContactsWelcome-list').first(),
			};
			$element.results = $element.list.find('[data-results="welcome"]').first().empty();

			$('body').append(
				$element.overlay,
				$element.list
			);

			$element.overlay.fadeIn();
			$element.list.show()
			setTimeout(function() {
				$element.list.removeClass('rotated');
			}, 1);

			$element.list.find('.chmContacts-search-close').on('click', function() {
				$element.overlay.trigger('click');
			});

			$element.overlay.on('click', function(event) {
				$element.list.addClass('rotated');;
				$element.overlay.fadeOut(function() {
					$element.overlay.hide();
					$element.list.hide();
				});
			});


			that.request(
				{
					action:'welcomeList'
				},
				function(resp) {
					var i;
					// console.log(resp);
					if (resp.success && resp.response.list) {
						$element.results.append(resp.response.list.join(''));
					} else {
						$element.results.append('Fehler beim Laden');
					}
				}
			);
		});
	});


	that = {
		request: function(data, callback, statusMessage) {
			var postData;
			postData = {
				action: chmContacts_params.ajaxAction,
				data: encodeURIComponent(JSON.stringify(data))
			};
			runningRequests++;
			$('.chmContacts_ControlPanel').addClass('loading');
			$('.chmContacts_ControlPanel').find('.loadingStatusMessage').remove();
			if (statusMessage) {
				$('.chmContacts_ControlPanel').append(
					$('<div>').addClass('loadingStatusMessage').html(statusMessage)
				);
			}
			$.post({
				url: chmContacts_params.ajaxUrl,
				data: postData,
				success: function(resp) {
					try {
						callback.call(chmContacts, resp);
					} catch(e) {
						console.log('[chmContacts:AJAX_ERROR] callback failed');
						console.log('response:');
						console.log(resp);
						console.log('callback:');
						console.log(callback);
						console.log('error:');
						console.log(e);
					}
				},
				error: function() {
					console.log('[chmContacts:AJAX_ERROR] request failed');
					console.log(data);
				},
				complete: function() {
					runningRequests--;
					if (runningRequests <= 0) {
						runningRequests = 0;
						$('.chmContacts_ControlPanel').removeClass('loading');
						$('.chmContacts_ControlPanel').find('.loadingStatusMessage').remove();
					}
				},
				dataType: 'json'
			});
		},
		render: function(contact, mode) {
			var classes;
			classes = [];
			if (contact.phone_internal != '') {
				classes.push('has-phone-internal');
			}
			if (contact.phone_dect != '') {
				classes.push('has-phone-dect');
			}
			if (contact.fax != '') {
				classes.push('has-fax');
			}
			if (contact.email != '') {
				classes.push('has-email');
			}
			if (contact.room != '') {
				classes.push('type-room');
			}

			return $('<div>').addClass('chmContact_Item '+mode+' '+classes.join(' ')).append(
				$('<div>').addClass("image").css({
					backgroundImage: contact.imageThumb ? 'url("'+contact.imageThumb+'")' : 'none'
				}),
				$('<div>').addClass("intro").append(
					$('<div>').addClass("room").text(contact.room),
					$('<div>').addClass("salutation").text(contact.salutation+' '+contact.title),
					$('<div>').addClass("name").append(
						$('<span>').text(contact.first_name+' '),
						$('<strong>').text(contact.name_prefix+' '+contact.last_name)
					),
					$('<div>').addClass("jobs").text(contact.jobsList + ((contact.representationsList != '') ? ', '+contact.representationsList : ''))
				),
				$('<div>').addClass('contact').append(
					$('<div>').addClass("phone phone-internal").attr('title', 'Telefon INTERN').append(
						$('<span>').addClass("icon").html('<i class="fas fa-phone"></i>'),
						// $('<span>').addClass("icon").attr('data-icon', ""),
						$('<span>').text(contact.phone_internal)
					),
					$('<div>').addClass("phone phone-dect").attr('title', 'Telefon DECT').append(
						$('<span>').addClass("icon").html('<i class="fas fa-mobile-alt"></i>'),
						// $('<span>').addClass("icon").attr('data-icon', ""),
						$('<span>').text(contact.phone_dect)
					),
					$('<div>').addClass("fax").attr('title', 'Fax').append(
						$('<span>').addClass("icon").html('<i class="fas fa-print"></i>'),
						// $('<span>').addClass("icon").attr('data-icon', ""),
						$('<span>').text(contact.fax)
					),
					$('<div>').addClass("email").append(
						$('<span>').addClass("icon").html('<i class="far fa-envelope"></i>'),
						// $('<span>').addClass("icon").attr('data-icon', ""),
						$('<a>').attr('href', 'mailto:'+contact.email).text(contact.email).on('click', function(event) {
							event.stopPropagation();
						})
					)
				),
				$('<div>').addClass('details').append(
					$('<div>').addClass("units").text(contact.unitsList),
					$('<div>').addClass("languages").append(
						(contact.languagesCount > 0)
						? $('<span>').addClass('itemsLabel').text(
							(contact.languagesCount > 1) ? 'Fremdsprachen: ' : 'Fremdsprache: '
						)
						: '',
						$('<span>').text(contact.languagesList)
					)
				)
			);
		}
	};

	return that;

})();
