var chmContacts_Search = (function() {
	var $ = jQuery;

	return function($container) {
		var $element, resultCache;

		resultCache = {};

		$element = {
			overlay: $container.find('.chmContacts-overlay'),
			searchBox: $container.find('.chmContacts-search-box'),
			input: $container.find('.chmContacts-search-input-text'),
			results: {}
		};

		$container.find('[data-results]').each(function() {
			var $target, mode;
			$target = $(this);
			mode = $target.attr('data-results');
			$element.results[mode] = $target;
			resultCache[mode] = {};
		});

		$container.find('.chmContacts-search-close').on('click', function() {
			$element.overlay.trigger('click');
		});

		$element.searchBox.on('click', function(event) {
			event.stopPropagation();
		});

		$element.overlay.on('click', function(event) {
			$element.searchBox.addClass('rotated');;
			$element.overlay.fadeOut(function() {
				$element.overlay.hide();
				$element.searchBox.hide();
			});
		});

		$element.input.on('input', function() {
			triggerInput();
		}).on('keydown', function(event) {
			if (event.which == 27) {
				if ($element.input.val() == '') {
					$element.overlay.trigger('click');
				} else {
					$element.input.val('');
					triggerInput();
				}
			}
		});

		var triggerInput = (function() {
			var timer;
			return function(delay) {
				var searchWords, searchMode, $activeTab;
				$activeTab = $element.searchBox.find('.chmContacts-search-tabs-tab.active');
				searchWords = $element.input.val();
				$activeTab.attr('data-search', searchWords);
				searchMode = $activeTab.attr('data-mode');

				delay = parseInt(delay, 10);
				if (isNaN(delay)) {
					delay = 500;
				}
				if (searchMode == 'contacts') {
					clearTimeout(timer);
					if (resultCache[searchMode].hasOwnProperty(searchWords)) {
						$element.results[searchMode].empty();
						renderResults(searchMode, searchWords);
					} else {
						timer = setTimeout(function() {
							$element.results[searchMode].empty().append(
								$('<div>').addClass('loading')
							);
							// chmContacts.request(
							// 	{
							// 		action: 'search',
							// 		mode: searchMode,
							// 		search: searchWords
							// 	}, function(resp) {
							// 		var i;
							// 		if (resp.success) {
							// 			resultCache[searchMode][searchWords] = resp.response;

							// 			$element.results[searchMode].empty();
							// 			renderResults(searchMode, searchWords);

							// 			// for (i = 0; i < resp.response.length; i++) {
							// 			// 	$element.results[searchMode].append(
							// 			// 		chmContacts.render(resp.response[i], 'item')
							// 			// 	);
							// 			// }
							// 		}
							// 	}
							// );
							fetchResults(searchMode, searchWords, undefined, function(contacts) {
								resultCache[searchMode][searchWords] = contacts;

								$element.results[searchMode].empty();
								renderResults(searchMode, searchWords);
							});
						}, delay);
					}
				} else {
					filterContacts(searchMode);
				}
			}
		})();

		$('.chmContacts-search-tabs-tab[data-list]').each(function() {
			var $tab, list, mode, i;
			$tab = $(this);
			list = JSON.parse(decodeURIComponent($tab.attr('data-list')));
			mode = $tab.attr('data-mode');
			$element.results[mode].empty();
			$element.results[mode].append(
				$('<div>').addClass('no-results').text('keine Einträge gefunden').hide()
			);

			for (i = 0; i < list.length; i++) {
				$element.results[mode].append(
					$('<div>').addClass("category").append(
						$('<div>').addClass("category-header").attr('data-mode', mode).attr('data-id', list[i].id).text(list[i].name).on('click', function() {
							var $header, $category;
							$header = $(this);
							$category = $header.closest('.category').toggleClass('open');
							if ($category.hasClass('open')) {
								loadResults($header.attr('data-mode'), $header.attr('data-id'));
							}
							$category.find('.category-results')[$category.hasClass('open') ? 'slideDown' : 'slideUp'](function() {
								$category.get(0).scrollIntoView(true);
							});
						}),
						$('<div>').addClass("category-results").attr('data-id', list[i].id).hide()
					)
				);
			}
		});

		$container.find('.chmContacts-search-trigger').on('click', function() {
			var searchMode;

			$element.overlay.fadeIn();
			$element.searchBox.show()
			setTimeout(function() {
				$element.searchBox.removeClass('rotated');
			}, 1);
			$element.input.focus().select();
			$element.searchBox.find('.chmContacts-search-tabs-tab').attr('data-search', '').on('click', function() {
				var $tab, prevVal;
				$tab = $(this);
				if (!$tab.hasClass('active')) {
					$element.searchBox.find('.chmContacts-search-tabs-tab').removeClass('active');
					$element.searchBox.find('[data-results]').hide();
					searchMode = $tab.addClass('active').attr('data-mode');
					$element.searchBox.find('[data-results="'+searchMode+'"]').show();
					// list = $tab.attr('data-list');
					prevVal = $element.input.val();
					$element.input.val($tab.attr('data-search'));
					if (prevVal != $element.input.val()) {
						triggerInput();
					}
					// if ($element.input.val() != '') {

					// 	if (searchMode != 'contacts') {
					// 		$element.input.val('');
					// 	}
					// triggerInput();
					// }
				}
				$element.input.focus();
			}).first().trigger('click');
		});

		$('body').append(
			$element.overlay,
			$element.searchBox
		);

		function fetchResults(searchMode, search, id, callback) {
			var contacts;
			contacts = [];
			loadMore(contacts, searchMode, search, id, 0, function() {
				console.log('fetchResults');
				console.log(contacts.length);
				callback(contacts);
			});
		}

		function loadMore(contacts, searchMode, search, id, offset, callback) {
			chmContacts.request(
				{
					action: 'search',
					mode: searchMode,
					search: search,
					id: id,
					offset: offset
				}, function(resp) {
					if (resp.success) {
						console.log('loadMore');
						console.log(resp.response.contacts.length);
						Array.prototype.push.apply(contacts, resp.response.contacts);
						if (resp.response.more) {
							loadMore(contacts, searchMode, search, id, resp.response.offset, callback);
						} else {
							callback();
						}
					} else {
						callback();
					}
				}
			);
		}

		function loadResults(searchMode, id) {
			var $target;
			if (!resultCache[searchMode].hasOwnProperty(id)) {

				if (id != '') {
					$target = $element.results[searchMode].find('.category-results[data-id="'+id+'"]');
				} else {
					$target = $element.results[searchMode];
				}
				$target.empty().append(
					$('<div>').addClass('loading')
				);

				// resultCache[mode][id] = [];
				// chmContacts.request(
				// 	{
				// 		action: 'search',
				// 		mode: searchMode,
				// 		// search: $element.input.val(),
				// 		id: id
				// 	}, function(resp) {
				// 		if (resp.success) {
				// 			resultCache[mode][id] = resp.response;
				// 			renderResults(mode, id);
				// 			// $element.input.val('');
				// 			// triggerInput(0);
				// 			try {
				// 				$element.results[mode].closest('.category').scrollIntoView(true);
				// 			} catch(ignore) {}
				// 		}
				// 	}
				// );

				resultCache[searchMode][id] = [];
				fetchResults(searchMode, undefined, id, function(contacts) {
					resultCache[searchMode][id] = contacts;
					renderResults(searchMode, id);
					try {
						$element.results[searchMode].closest('.category').scrollIntoView(true);
					} catch(ignore) {}
				});
			} else {
				//triggerInput(0);
			}
		}

		function renderResults(searchMode, id) {
			var results, $target, $row;

			results = resultCache[searchMode][id];
			if (searchMode != 'contacts') {
				$target = $element.results[searchMode].find('.category-results[data-id="'+id+'"]');
			} else {
				$target = $element.results[searchMode];
			}
			$target.empty();

			if (results.length > 0) {
				for (i = 0; i < results.length; i+=2) {
					$row = $('<div>').addClass('chmContact_Item-container');
					$row.append(
						chmContacts.render(results[i], 'item')
					);
					if ((i+1) < results.length) {
						$row.append(
							chmContacts.render(results[i+1], 'item')
						);
					}
					$target.append($row);
					$element.input.focus();
				}
			} else {
				$target.append(
					$('<div>').addClass('no-results').text('keine Einträge gefunden')
				);
			}

			try {
				$target.closest('.category').get(0).scrollIntoView(true);
			} catch(ignore) {}
		}


		function filterContacts(searchMode) {
			var keywords, $categories, hidden;

			keywords = String($element.input.val()).toLowerCase().split(' ');
			hidden = 0;

			$categories = $element.results[searchMode].find('.category');

			//filter categories
			$categories.each(function() {
				var i, keyword, $category, text;
				$category = $(this);
				text = String($category.find('.category-header').text()).toLowerCase();
				for (i = 0; i < keywords.length; i++) {
					keyword = keywords[i];
					if (keyword.length > 0) {
						if (text.indexOf(keyword) < 0) {
							if ($category.is(':visible')) {
								$category.hide();
							}
							hidden++;
							return;
						}
					}
				}
				if (!$category.is(':visible')) {
					$category.show();
				}
			});

			$element.results[searchMode].find('.no-results')[(hidden == $categories.length) ? 'show' : 'hide']();
		}
	}

})();